// @codekit-prepend "jquery.js";
// @codekit-prepend "superfish.js";
// @codekit-prepend "tinynav.js";
// @codekit-prepend "fitvids.js";

$(document).ready(function () {
  /*
     ------------------------------------
     Site navigation
     ------------------------------------
  */

  $('.site-navigation-inner').superfish({
    delay: 500,
    animation: { height: 'show' },
    speed: 'fast',
    autoArrows: false
  })

  /*
     ------------------------------------
    TinyNav
     ------------------------------------
  */

  $('.site-navigation-inner > ul').tinyNav()
  $('.site-navigation-inner select').wrap('<div class="select"></div>')

  /*
     ------------------------------------
    Housekeeping
     ------------------------------------
  */

  var logoW = $('.site-logo img').width()
  $('.site-logo img').width(logoW/2)

  $('br').remove()

  /*
     ------------------------------------
     Gallery
     ------------------------------------
  */

  $('.thumbnail-wrap, .thumbnail-frame').attr('style', '')

  if ($('.photo-frame')[0]) {
    var imgSrc = $('.photo-frame').attr('src')
    $('.photo-background').attr('style', 'background-image: url("' + imgSrc + '");')
    $('body').append('<div class="body-overlay"></div>')

    var photoW = $('.photo-frame').attr('width') / 2
    var photoH = $('.photo-frame').attr('height') / 2
    $('.photo-frame').attr('style', 'margin-left: -' + photoW + 'px; margin-top: -' + photoH + 'px;')
  }

  /*
     ------------------------------------
     Fitvids
     ------------------------------------
  */

  $('.site-content').fitVids()
  $('.site-content-inner > iframe').wrap('<div class="embed-responsive embed-responsive-16by9"></div>')

  /*
     ------------------------------------
     Function to generate "open in new
     window" link as W3C compliant
     ------------------------------------
  */

  function externalLinks () {
    if (!document.getElementsByTagName) return
    var anchors = document.getElementsByTagName('a')

    for (var i = 0; i < anchors.length; i++) {
      var anchor = anchors[i]

      if (anchor.getAttribute('href') && anchor.getAttribute('rel') === 'external') {
        anchor.target = '_blank'
      }
    }
  }
  window.onload = externalLinks
})
